/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.widget;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.OverlayLayout;
import javax.swing.event.MouseInputAdapter;
import tiled.core.Map;
import tiled.view.MapView;

public class ResizePanel
extends JPanel {
    private MapView inner;
    private Map currentMap;
    private Dimension oldDim;
    private Dimension newDim;
    private int offsetX;
    private int offsetY;
    private Point startPress;
    private double zoom;

    public ResizePanel() {
        this.setLayout(new OverlayLayout(this));
        this.setBorder(BorderFactory.createLoweredBevelBorder());
    }

    public ResizePanel(Map map) {
        this();
        Dimension old;
        this.zoom = 0.1;
        this.currentMap = map;
        DragHandler dragHandler = new DragHandler();
        this.inner = MapView.createViewforMap(map);
        this.inner.setZoom(this.zoom);
        this.inner.addMouseListener(dragHandler);
        this.inner.addMouseMotionListener(dragHandler);
        this.add(this.inner);
        this.oldDim = old = this.inner.getPreferredSize();
        this.setSize(old);
    }

    public ResizePanel(Dimension size, Map map) {
        this(map);
        this.oldDim = size;
        this.newDim = size;
        this.setSize(size);
    }

    public void moveMap(int x, int y) {
        this.inner.setLocation((int)((double)x * ((double)this.currentMap.getTileWidth() * this.zoom)), (int)((double)y * ((double)this.currentMap.getTileHeight() * this.zoom)));
    }

    public void setNewDimensions(Dimension n) {
        this.newDim = n;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.oldDim;
    }

    public double getZoom() {
        return this.zoom;
    }

    private class DragHandler
    extends MouseInputAdapter {
        private DragHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            ResizePanel.this.startPress = e.getPoint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            ResizePanel.this.startPress = null;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int newOffsetX = ResizePanel.this.offsetX + (e.getX() - ((ResizePanel)ResizePanel.this).startPress.x);
            int newOffsetY = ResizePanel.this.offsetY + (e.getY() - ((ResizePanel)ResizePanel.this).startPress.y);
            newOffsetX = (int)((double)newOffsetX / ((double)ResizePanel.this.currentMap.getTileWidth() * ResizePanel.this.zoom));
            newOffsetY = (int)((double)newOffsetY / ((double)ResizePanel.this.currentMap.getTileHeight() * ResizePanel.this.zoom));
            if (newOffsetX != ResizePanel.this.offsetX) {
                ResizePanel.this.firePropertyChange("offsetX", ResizePanel.this.offsetX, newOffsetX);
                ResizePanel.this.offsetX = newOffsetX;
            }
            if (newOffsetY != ResizePanel.this.offsetY) {
                ResizePanel.this.firePropertyChange("offsetY", ResizePanel.this.offsetY, newOffsetY);
                ResizePanel.this.offsetY = newOffsetY;
            }
        }
    }
}

